function varargout = Hydrogenoide(varargin)
% HYDROGENOIDE M-file for Hydrogenoide.fig
%      HYDROGENOIDE, by itself, creates a new HYDROGENOIDE or raises the existing
%      singleton*.
%
%      H = HYDROGENOIDE returns the handle to a new HYDROGENOIDE or the handle to
%      the existing singleton*.
%
%      HYDROGENOIDE('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in HYDROGENOIDE.M with the given input arguments.
%
%      HYDROGENOIDE('Property','Value',...) creates a new HYDROGENOIDE or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before Hydrogenoide_OpeningFcn gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to Hydrogenoide_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help Hydrogenoide

% Last Modified by GUIDE v2.5 31-Jul-2010 22:59:00
% Olivier Pujol : septembre 2013

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @Hydrogenoide_OpeningFcn, ...
                   'gui_OutputFcn',  @Hydrogenoide_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before Hydrogenoide is made visible.
function Hydrogenoide_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to Hydrogenoide (see VARARGIN)

% Choose default command line output for Hydrogenoide
handles.output = hObject;

% Update handles structure
guidata(hObject, handles);

% UIWAIT makes Hydrogenoide wait for user response (see UIRESUME)
% uiwait(handles.Hydrogenoide);

% --- Outputs from this function are returned to the command line.
function varargout = Hydrogenoide_OutputFcn(hObject, eventdata, handles) 
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;

% --- Executes during object creation, after setting all properties.
%function ntext_CreateFcn(hObject, eventdata, handles)
% hObject    handle to ntext (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

function n_Callback(hObject, eventdata, handles)
% hObject    handle to n (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of n as text
%        str2double(get(hObject,'String')) returns contents of n as a double

% --- Executes during object creation, after setting all properties.
function n_CreateFcn(hObject, eventdata, handles)
% hObject    handle to n (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

function l_Callback(hObject, eventdata, handles)
% hObject    handle to l (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of l as text
%        str2double(get(hObject,'String')) returns contents of l as a double

% --- Executes during object creation, after setting all properties.
function l_CreateFcn(hObject, eventdata, handles)
% hObject    handle to l (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

function Z_Callback(hObject, eventdata, handles)
% hObject    handle to Z (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Z as text
%        str2double(get(hObject,'String')) returns contents of Z as a double

% --- Executes during object creation, after setting all properties.
function Z_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Z (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

function k_Callback(hObject, eventdata, handles)
% hObject    handle to k (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of k as text
%        str2double(get(hObject,'String')) returns contents of k as a double

% --- Executes during object creation, after setting all properties.
function k_CreateFcn(hObject, eventdata, handles)
% hObject    handle to k (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

function NbPoints_Callback(hObject, eventdata, handles)
% hObject    handle to NbPoints (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of NbPoints as text
%        str2double(get(hObject,'String')) returns contents of NbPoints as a double

% --- Executes during object creation, after setting all properties.
function NbPoints_CreateFcn(hObject, eventdata, handles)
% hObject    handle to NbPoints (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

% --- Executes on button press in PartieRadiale.
function PartieRadiale_Callback(hObject, eventdata, handles)
% hObject    handle to PartieRadiale (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

n=str2double(get(handles.n,'String'));    % Valeur de n (nombre quantique principal)
l=str2double(get(handles.l,'String'));    % Valeur de l (Moment cintique)
Z=str2double(get(handles.Z,'String'));    % Valeur de Z (Nombre atomique)

k=str2double(get(handles.k,'String'));                  % Valeur de k (Extension x=r/aB)
NbPoints=str2double(get(handles.NbPoints,'String'));    % Valeur de NbPoints (Nombre de points)

PartieRadiale(Z,n,l,NbPoints,k);

function m_Callback(hObject, eventdata, handles)
% hObject    handle to m (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of m as text
%        str2double(get(hObject,'String')) returns contents of m as a double

% --- Executes during object creation, after setting all properties.
function m_CreateFcn(hObject, eventdata, handles)
% hObject    handle to m (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

% --- Executes on button press in DaProba.
function DaProba_Callback(hObject, eventdata, handles)
% hObject    handle to DaProba (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

m=str2double(get(handles.m,'String'));
l=str2double(get(handles.l,'String'));

HarmoniqueSpherique(l,m);

function angpolval_Callback(hObject, eventdata, handles)
% hObject    handle to angpolval (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of angpolval as text
%        str2double(get(hObject,'String')) returns contents of angpolval as a double

% --- Executes during object creation, after setting all properties.
function angpolval_CreateFcn(hObject, eventdata, handles)
% hObject    handle to angpolval (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

function raBval_Callback(hObject, eventdata, handles)
% hObject    handle to raBval (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of raBval as text
%        str2double(get(hObject,'String')) returns contents of raBval as a double

% --- Executes during object creation, after setting all properties.
function raBval_CreateFcn(hObject, eventdata, handles)
% hObject    handle to raBval (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

% --- Executes on button press in DvProba.
function DvProba_Callback(hObject, eventdata, handles)
% hObject    handle to DvProba (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

n=str2double(get(handles.n,'String'));    % Valeur de n (nombre quantique principal)
l=str2double(get(handles.l,'String'));    % Valeur de l (Moment cintique)
m=str2double(get(handles.m,'String'));    % Valeur de m (Moment magntique)
Z=str2double(get(handles.Z,'String'));    % Valeur de Z (Nombre atomique)

angpol=str2double(get(handles.angpolval,'String'));    % Valeur de l'angle polaire phi (Trac 2D)
raB=str2double(get(handles.raBval,'String'));          % Valeur de r/aB (Trac 3D)

NbPointsAng = 101;      % Nombre de points --> Rsolution angulaire : 2*pi/(NbPoints-1) = 0,005*pi
NbPointsRad = str2double(get(handles.NbPoints,'String'));   % Nombre de points minimal pour la coordonne radiale r 
k=str2double(get(handles.k,'String'));      % Valeur de k (Extension x=r/aB)

[CoordSph,psi,rho]=FonctionOnde(n,l,m,Z,NbPointsRad,NbPointsAng,k);
GraphFoncOnd(CoordSph,psi,rho,angpol,raB);

clear CoordSph psi rho


% --- Executes on button press in Fermer.
function Fermer_Callback(hObject, eventdata, handles)
% hObject    handle to Fermer (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

close all


